#include <windows.h>
#include "lx.h"

LPTSTR service_name = "MXMapper";
HANDLE service_handle;
SERVICE_STATUS service_status;
HANDLE thread_handle[8];
struct lx_t lxs[8];
mi_go_t go[8];

DWORD WINAPI mapper_thread(LPVOID p)
{
  mi_go_t *go = (mi_go_t*)p;
  mi_go (go->lx, go->unit);
  return 0;
}

int board_count(void)
{
  char buff[80];
  HANDLE h;
  int i;

  i = 0;
  sprintf(buff, "\\\\.\\mx%d", i);
  h = CreateFile(buff, GENERIC_READ | GENERIC_WRITE, 0, NULL,
		 OPEN_EXISTING, FILE_ATTRIBUTE_SYSTEM, NULL);
  while (h != INVALID_HANDLE_VALUE) {
    CloseHandle(h);
    ++i;
    sprintf(buff, "\\\\.\\mx%d", i);
    h = CreateFile(buff, GENERIC_READ | GENERIC_WRITE, 0, NULL,
		   OPEN_EXISTING, FILE_ATTRIBUTE_SYSTEM, NULL);
  }
  return i;
}

VOID WINAPI service_handler(DWORD fdwControl)
{
  int count;
  int i;

  switch(fdwControl) {
  case SERVICE_CONTROL_STOP:
    service_status.dwCurrentState = SERVICE_STOP_PENDING;
    service_status.dwCheckPoint++;
    service_status.dwWaitHint = 5000;
    SetServiceStatus(service_handle, &service_status);

    /* kill mapper threads */
    count = board_count ();
    for (i = 0; i < count; ++i) {
      go[i].lx->aborted = 1;
      go[i].lx->die = 1;
    }
    if (count > 0) {
      WaitForMultipleObjects (count, thread_handle, TRUE, INFINITE);
    }

    service_status.dwCurrentState = SERVICE_STOPPED;
    service_status.dwCheckPoint = 0;
    service_status.dwWaitHint = 0;
    SetServiceStatus(service_handle, &service_status);
    break;
  case SERVICE_CONTROL_PAUSE:
    break;
  case SERVICE_CONTROL_CONTINUE:
    break;
  case SERVICE_CONTROL_INTERROGATE:
    service_status.dwCurrentState = SERVICE_RUNNING;
    service_status.dwCheckPoint = 0;
    service_status.dwWaitHint = 0;
    SetServiceStatus(service_handle, &service_status);
    break;
  case SERVICE_CONTROL_SHUTDOWN:
    break;
  default:
    break;
  }
}

VOID WINAPI service_main(DWORD dwArgc, LPTSTR* lpszArgv)
{
  int count;
  int i;

  service_handle = RegisterServiceCtrlHandler(service_name,
					      service_handler);
  service_status.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
  service_status.dwCurrentState = SERVICE_START_PENDING;
  service_status.dwControlsAccepted = SERVICE_ACCEPT_STOP;
  service_status.dwWin32ExitCode = NO_ERROR;
  service_status.dwServiceSpecificExitCode = 0;
  service_status.dwCheckPoint = 0;
  service_status.dwWaitHint = 1000;
  SetServiceStatus(service_handle, &service_status);

  /* spawn thread per mapper */
  count = board_count ();
  for (i = 0; i < count; ++i)
  {
    lxs [i].level = 1;
    lxs [i].map_once = 0;
    lxs [i].xbar_verify_flag = LX_FLAG_XBAR_VERIFY_CLOS;
    lxs [i].routing_flag = LX_FLAG_ROUTING_CAREFUL;
    lxs [i].pause = 0;
    lxs [i].extra_hosts = 0;
    lxs [i].thrash = 0;
    lxs [i].seek_size = LX_SEEK_SIZE;
    lxs [i].active_tries = LX_ACTIVE_TRIES;
    lxs [i].route_filebase = NULL;

    go [i].lx = &lxs [i];
    go [i].unit = i;
    thread_handle[i] = CreateThread (NULL, 0, mapper_thread, go+i,
				     0 /*CREATE_SUSPENDED*/, NULL);
  }

  service_status.dwCurrentState = SERVICE_RUNNING;
  service_status.dwCheckPoint++;
  service_status.dwWaitHint = 0;
  SetServiceStatus(service_handle, &service_status);
}

void windows_service(void)
{
  SERVICE_TABLE_ENTRY service_table[] =
  {
    { service_name, service_main },
    { NULL, NULL}
  };

  StartServiceCtrlDispatcher(service_table);
}
